#!/bin/bash
#
#  File: setup-service-instances.sh
#
#  Copyright 2025 Penguin Solutions Inc.  All Rights Reserved.
#


function showUsage() {
    echo "Usage: `basename $0` <options> <service tag>"
    echo "   --remove|-r          remove setup"
    echo "   --quiet|-q           no output"
    echo "   --help|-h            this help"
    echo
    echo "Copyright 2025 Penguin Solutions Inc.  All Rights Reserved."
}


REMOVE=0
QUIET=0

# Iterate through args looking for optionals
while [[ $# -ge 1 ]]; do
    key="$1"
    case $key in
        --quiet|-q)
            QUIET=1
            ;;
        --remove|-r)
            REMOVE=1
            ;;
        --help|-h)
            showUsage
            exit 0
            ;;
        *)
            EXT=$key
            ;;
    esac
    shift
done

if [[ "${EXT}" == "" ]]; then
    echo "Need service extension. Exiting ... "
    exit
fi

if [[ "${REMOVE}" == "0" ]]; then

    if [[ ! -x /opt/ice-remoteware/bin/ice-remoteware-${EXT} ]]; then
        ln -s  /opt/ice-remoteware/bin/ice-remoteware  /opt/ice-remoteware/bin/ice-remoteware-${EXT}
    fi

    if [[ ! -f /opt/ice-remoteware/ice-remoteware-${EXT}.xml ]]; then
        if [[ ${QUIET} -eq 0 ]]; then
            echo "Please modify /opt/ice-remoteware/ice-remoteware-${EXT}.xml"
            echo "    - port number (must be unique)"
            echo "    - X11 display/seat information"
            echo ""
            echo "See also /opt/ice-remoteware/examples/configs/ice-remoteware.MultiServer.xml"
        fi
        cp  /opt/ice-remoteware/ice-remoteware.xml /opt/ice-remoteware/ice-remoteware-${EXT}.xml
        chmod g+w /opt/ice-remoteware/ice-remoteware-${EXT}.xml
    fi

else

    rm -fr /opt/ice-remoteware/bin/ice-remoteware-${EXT}

    if [[ -f /opt/ice-remoteware/ice-remoteware-${EXT}.xml ]]; then
        echo "Please remove /opt/ice-remoteware/ice-remoteware-${EXT}.xml manually"
    fi
fi
