#!/bin/bash
#
#  File: linux-clone-user.sh
#
#  Copyright 2024-2025 Penguin Computing Inc.  All Rights Reserved.
#

CURR_USER=`whoami`

if [[ ${CURR_USER} != "root" ]]; then
	echo "Please run this script with root priviliges"
	exit -1
fi

# creates new user and copies another users profile
# Usage: clone-user src_user_name new_user_name
SRC_USER=$1
NEW_USER=$2

if [[ "${NEW_USER}" == "" ]]; then
	echo "Usage: linux-clone-user.sh <old_user> <new_user>"
	exit -1
fi

id -Gn ${SRC_USER} > /dev/null 2>&1

if [[ $? -ne 0 ]]; then
	echo "User ${SRC_USER} not found. Giving up"
	exit 1
fi

id -Gn ${NEW_USER} > /dev/null 2>&1

if [[ $? -eq 0 ]]; then
	echo "User ${NEW_USER} already configured. Exiting."
	exit 1
fi

SRC_USER_GROUPS=$(id -Gn ${SRC_USER} | sed "s/ /,/g" | sed -r 's/\<'${SRC_USER}'\>\b,?//g')
SRC_USER_SHELL=$(awk -F : -v name=${SRC_USER} '(name == $1) { print $7 }' /etc/passwd)
SRC_USER_HOME=$(awk -F : -v name=${SRC_USER} '(name == $1) { print $6 }' /etc/passwd)

echo "Creating user ${NEW_USER}"

if [[ -z ${SRC_USER_GROUPS} ]]; then
	useradd --shell ${SRC_USER_SHELL} --create-home ${NEW_USER}
else
	useradd --groups ${SRC_USER_GROUPS} --shell ${SRC_USER_SHELL} --create-home ${NEW_USER}
fi

echo "Setting password for user ${NEW_USER}"
passwd ${NEW_USER}

NEW_USER_HOME=$(awk -F : -v name=${NEW_USER} '(name == $1) { print $6 }' /etc/passwd)

if [[ -d ${SRC_USER_HOME}/.ssh ]]; then
	echo "Copying ${SRC_USER_HOME}/.ssh to ${NEW_USER_HOME}"
	cp -r  ${SRC_USER_HOME}/.ssh ${NEW_USER_HOME}/.ssh
	if [[ -f ${NEW_USER_HOME}/.ssh/config ]]; then
		sed -i "s^${SRC_USER}^${NEW_USER}^g" ${NEW_USER_HOME}/.ssh/config
	fi
	chmod -R og-rwx  ${NEW_USER_HOME}/.ssh
	chown -R ${NEW_USER} ${NEW_USER_HOME}/.ssh
fi
